/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.datagen;

import com.google.gson.JsonObject;
import com.rcx.materialis.MaterialisResources;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import slimeknights.tconstruct.common.registration.CastItemObject;

public class MaterialisItemModels
extends ItemModelProvider {
    public MaterialisItemModels(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "materialis", existingFileHelper);
    }

    protected void registerModels() {
        for (MaterialisResources.FluidWithBlockNBucket fluid : MaterialisResources.fluidList) {
            this.bucketModel(fluid.FLUID_BUCKET);
        }
        for (MaterialisResources.IngotWithBlockNNugget material : MaterialisResources.materialList) {
            this.itemWithModel(material.INGOT, "item/generated");
            this.itemWithModel(material.NUGGET, "item/generated");
        }
        this.castModels(MaterialisResources.INLAY_CAST);
        this.castModels(MaterialisResources.WRENCH_HEAD_CAST);
    }

    public void itemWithModel(RegistryObject<? extends Item> registryObject, String model) {
        ResourceLocation id = registryObject.getId();
        ResourceLocation textureLocation = new ResourceLocation(id.m_135827_(), "item/" + id.m_135815_());
        this.singleTexture(id.m_135815_(), new ResourceLocation(model), "layer0", textureLocation);
    }

    public void castModels(CastItemObject cast) {
        ResourceLocation idGold = ((Item)cast.get()).getRegistryName();
        ResourceLocation textureLocationGold = new ResourceLocation(idGold.m_135827_(), "item/" + idGold.m_135815_());
        this.singleTexture(idGold.m_135815_(), new ResourceLocation("item/generated"), "layer0", textureLocationGold);
        ResourceLocation idSand = cast.getSand().getRegistryName();
        ResourceLocation textureLocationSand = new ResourceLocation(idSand.m_135827_(), "item/" + idSand.m_135815_());
        this.singleTexture(idSand.m_135815_(), new ResourceLocation("item/generated"), "layer0", textureLocationSand);
        ResourceLocation idSandRed = cast.getRedSand().getRegistryName();
        ResourceLocation textureLocationSandRed = new ResourceLocation(idSandRed.m_135827_(), "item/" + idSandRed.m_135815_());
        this.singleTexture(idSandRed.m_135815_(), new ResourceLocation("item/generated"), "layer0", textureLocationSandRed);
    }

    public void bucketModel(final RegistryObject<? extends BucketItem> registryObject) {
        ModelBuilder builder = ((ItemModelBuilder)this.getBuilder(registryObject.getId().m_135815_())).parent((ModelFile)this.getExistingFile(new ResourceLocation("materialis", "item/bucket_fluid")));
        builder.customLoader((t, u) -> new CustomLoaderBuilder(((ModelBuilder)t).getLocation(), (ModelBuilder)t, (ExistingFileHelper)u){

            public JsonObject toJson(JsonObject json) {
                json.addProperty("loader", "forge:bucket");
                json.addProperty("fluid", ((BucketItem)registryObject.get()).getFluid().getRegistryName().toString());
                return json;
            }
        });
    }
}

